require( "quest/m3_lobby/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("flo");
		actor:SetScale( 0.75 );
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		actor:SetWalkSpeed(flo_speed);
		actor:SetMode(MODE.CUTSCENE);
		
		lastScene = game:GetLastScene();
		if lastScene == "m3_maze1" then
			actor:FaceNow(DIR.S);
			actor:JumpToNamedPoint("maze");
			actor:WalkTo("flo");
		elseif lastScene == "m3_landing13" or lastScene == "m3_landing50" then
			actor:FaceNow(DIR.S);
			actor:JumpToNamedPoint("elevator");
			sfx:PlaySFX("audio/sfx/big_elevator");
			scene.ELEVATOR:PlayAnim("Close");
			actor:WalkTo("flo");
		else
			actor:FaceNow(DIR.E);
			actor:JumpToNamedPoint("exit");
			actor:WalkTo("flo");
		end
		
		wait_walkto();
		actor:Face(DIR.W);
		
		if game:Get("first_time_bigcorp_lobby") < 1 then
			game:Set("first_time_bigcorp_lobby", 1);
			run_super_conversation(actor, "conv_lobby_intro");
		end
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	on_arrive = function(flo, button)
		if ( game:Get( "talked_to_tina_1" ) == 1 ) then
			if ( game:Get( "talked_to_tina_2" ) == 1 ) then
				if ( game:Get( "got_permit_signed" ) == 1 and game:Get( "got_permit_stamped" ) == 1 ) then
					flo:StartProc(enough);		
				else
					flo:StartProc(business_time);		
				end
			else
				flo:StartProc(find_people);				
			end
		else
			convproc("FLO", "quip_bigcorp_music");		
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function enough(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_lobby_flo_C");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function business_time(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_lobby_flo_B");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function find_people(flo)
	flo:SetMode(MODE.CUTSCENE);
	if AllCardsSigned() then
		run_super_conversation(flo, "quip_bigcorp_music");
	else
		run_super_conversation(flo, "quip_lobby_flo_A");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function need_keycard(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_need_keycard");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function no_need(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_no_need");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function no_more(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_no_more");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function use_keycard(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_lobby_use_keycard");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function ponder_globe(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_globe");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function goto_level_13(flo)
	flo:SetMode(MODE.CUTSCENE);
	game:ClearInvUsage();
	sfx:PlaySFX("audio/sfx/big_elevator");
	scene.ELEVATOR:PlayAnim("Open");
	scene.ELEVATOR_BUTTON:PlayAnim("Up");
	flo:WalkTo("elevator");
	wait_walkto();
	
	goto_scene(flo, "m3_landing13");
end

function goto_level_50(flo)
	flo:SetMode(MODE.CUTSCENE);
	game:ClearInvUsage();
	sfx:PlaySFX("audio/sfx/big_elevator");
	scene.ELEVATOR:PlayAnim("Open");
	scene.ELEVATOR_BUTTON:PlayAnim("Up");
	flo:WalkTo("elevator");
	wait_walkto();
	
	goto_scene(flo, "m3_landing50");
end

elevator_spec =
{
	name = "ELEVATOR";
	halo = "elevator";
	gfx = { anim = "anim/m3_lobby/elevator_door" };
	
	command = function(actor)
		actor:SetDepthValue(2);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Closed");
	end;
	
	on_arrive = function(flo, elevator)		
		if ( game:Get( "got_permit_stamped" ) == 1 ) then
			flo:StartProc(no_need);
		else
			if ( game:Get( "talked_to_tina_1" ) == 1 ) then
				flo:StartProc(use_keycard);
			else
				flo:StartProc(need_keycard);
			end
		end		
	end;
	
	on_use_inv = function(item, flo, tina)
		if ( game:Get( "got_permit_stamped" ) == 1 ) then
			flo:StartProc(no_need);
		elseif ( item == "keycard" ) then		
			flo:StartProc(goto_level_13);
		elseif ( item == "bluekey" ) then
			flo:StartProc(goto_level_50);
		else
			flo:StartProc(need_keycard);
		end		
	end;
};

elevator_button_spec = 
{
	name = "ELEVATOR_BUTTON";
	gfx = { anim = "anim/m3_lobby/elevator_button" };
	
	command = function(actor)
		actor:SetDepthValue(1);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Off");
	end;
}

function goto_big(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("exit");
	wait_walkto();
	goto_scene(flo, "m3_big");
end;

exit_spec =
{
	name = "EXIT";
	halo = "exit";
	--gfx = { image = "exit"};
	depth = 3;
	cursor = "cursor_arrow_w";
	goto_fn = goto_big;
};

globe_spec =
{
	name = "GLOBE";
	halo = "globe";
	
	on_click = function(flo, globe)
		flo:StartProc(ponder_globe);
	end;
};

function goto_maze(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("maze");
	wait_walkto();
	
	goto_scene(flo, "m3_maze1");
end

maze_spec =
{
	name = "MAZE";
	halo = "maze";
	
	command = function(actor)
		actor:SetDepthValue(4);
		actor:SetPointAtCursor("cursor_arrow_e");
	end;
	
	on_arrive = function(flo, maze)
		if ( game:Get( "talked_to_tina_2" ) == 1 ) then
			flo:StartProc(no_go);
		elseif ( game:Get( "talked_to_tina_1" ) == 1 ) then
			flo:StartProc(goto_maze);
		else
			flo:StartProc(better_check);
		end
	end;
};

function no_go(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_lobby_no_go");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function better_check(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_better_check");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

tina_anim_table = 
{
	"anim/tina/stand",
	"anim/tina/talk",
};

function talk_to_tina(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:FaceActor(tina);

	if ( game:Get( "got_permit_stamped" ) == 1 ) then
		run_super_conversation(flo, "conv_lobby_done");
	elseif ( game:Get( "got_permit_signed" ) == 1 and game:Get( "got_permit_stamped" ) ~= 1 ) then
		run_super_conversation(flo, "conv_lobby_need_stamp");
	elseif ( game:Get( "got_permit" ) == 1 and game:Get( "visited_signatures_office" ) ~= 1 ) then
		run_super_conversation(flo, "conv_lobby_need_sig");
	elseif ( game:Get( "visited_permits_office" ) == 1 and game:Get( "got_permit" ) ~= 1 ) then
		run_super_conversation(flo, "conv_lobby_need_permit");
	elseif ( game:Get( "talked_to_tina_2" ) == 1 ) then
		run_super_conversation(flo, "conv_got_keycard");
	elseif ( game:Get( "talked_to_tina_1" ) == 1 ) then
		run_super_conversation(flo, "conv_1");
	else -- hasn't talked to Tina yet
		run_super_conversation(flo, "conv_get_permit");
		addInventory( inv_desc_card );
		game:Set( "talked_to_tina_1", 1 );
		
		if not quest_added("keycard1") then
			add_quest("keycard1");
			wait_subscene();
		end
	end
	
	flo:Face(DIR.W);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function rings(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_lobby_rings");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

tina_spec = 
{
	name = "TINA";
	halo = "quest/objects/tina";
	anim = tina_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, tina_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);		
		actor:FaceNow(DIR.W);
		--actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(secretary_speed);
		actor:SetDepthValue( 423 );
		actor:JumpToNamedPoint("tina");
	end;
	
	on_arrive = function(flo, tina)
		if( game:Get( "got_permit_stamped" ) == 1 ) then
			flo:StartProc(no_more);
		elseif game:Get( "talked_to_tina_1" ) == 1 then
			if AllCardsSigned() == false then
				flo:StartProc(need_more_sigs);	
			else
				convproc("FLO", "conv_need_more_sigs");
			end
		elseif quest_added("give_permit") then
			flo:StartProc(talk_to_tina);
		else
			flo:StartProc(rings);
		end
	end;
	
--	on_arrive = function(flo, tina)
--	end;
	
	on_use_inv = function(item, flo, tina)
		--scene.debugPrint:JumpToPoint( flo:GetPosition() );
		--scene.debugPrint:SayRaw( tostring(item) );
		if ( item == "card" ) then
			if ( AllCardsSigned() ) then
				flo:StartProc(get_keycard);	
			else
				flo:StartProc(need_more_sigs);	
			end
		elseif quest_added("give_permit") then
			flo:StartProc(talk_to_tina);
		end		
	end;
};

function need_more_sigs(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_need_more_sigs");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_keycard(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_get_keycard");
	game:Set( "talked_to_tina_2", 1 );
	BAG_INV:RemoveInventory( "card" );
	addInventory( inv_desc_keycard );
	complete_quest("keycard1");
	wait_subscene();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function AllCardsSigned()	
	for i = 1, 5 do
		if ( game:Get( "cubicle" .. tostring(i) .."_signed" ) ~= 1 ) then
			return false;
		end
	end
	return true;
end

mrbig_anim_table =
{
	"anim/mrbig/stand",
	"anim/mrbig/talke",
};

mrbig_spec = 
{
	name = "MRBIG";
	halo = "quest/objects/derekw";
	anim = mrbig_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, mrbig_text_spec);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(mrbig_speed);
		actor:JumpToNamedPoint("mrbig");
		actor:FaceNow(DIR.W);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_big_corp.ogg", true);
		scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
			--BAG_INV:AddInventory(inv_desc_bluekey);
			--BAG_INV:AddInventory(inv_desc_keycard);
		end
		
		if game:Get("first_time_bigcorp_lobby") < 1 then
			scene:Spawn(mrbig_spec);
		end
		
		spawn_nav_arrow(exit_spec);
		
		scene:Spawn(flo_spec); -- flo spawns last
		
		game:SetString("map_position", "m3_lobby");
	end;
};

debugPrint_spec =
{
	name = "debugPrint";
	
	command = function(actor)
		actor:SetDepthValue( 3000 );
		
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			y = 30,
			x = -15,
			w = 90,
			h = 25,
			bubble = false,
			outline_size = 0,
			font = "fonts/garamondpremierpro.mvec"; 
			anchor = ANCHOR.CENTER
		};
	end;
}

big_corp_sign_spec = 
{
	name = "BIG_CORP_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(100);
		actor:ModifySaySpec
		{
			font = "fonts/revue_std.mvec",
			color = { a = 1, r = 0.12, g = 0.23, b = 0.39 },
			outline_size = 0,
			lineheight = 60,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		actor:SetWalkSpeed(0);
		
		actor:Say("text_big_corp_sign");
		actor:StopWalking();
		actor:SetPolygon({x=333,y=67}, {x=485,y=69}, {x=335,y=183}, {x=485,y=184});
		actor:TextToImage(10, 10);
	end;
}

scene_spec =
{
	atlas = 
	{
		"pieces" -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "ball", 100 },
		{ "desk", 420 },
		{ "small_screen", 425 },
		{ "right_front_chair", DEPTH.DEPTH_FRONTMOST },
		{ "left_front_chair", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		maze_spec,
		elevator_spec,
		elevator_button_spec,
		globe_spec,
		
		tina_spec,
		
		scene_setup,
		debugPrint_spec,
		big_corp_sign_spec,
	};
};
